 aR  w - mP9      h	 o       nSystem-wide%SET (supportsEmsWindows, 0)
$NOLIST

NAME  ScreenSubroutines

CGROUP GROUP CODE

EXTRN   screenSeg: ABS, bitsPerPixel: ABS

PUBLIC  scrOrientation

PUBLIC  ScrSetScreenOrientation, ScrWindowByteSize
PUBLIC  RotatePtsNorth, InitWinParms, StartPosition

%IF (%supportsEmsWindows EQ 1) THEN (
PUBLIC  RestoreEmsSlot

EXTRN   emsBase:WORD
) FI


north       EQU 0
west	     EQU 1
south       EQU 2
east	     EQU 3

notNorth    EQU 11b
westOrEast  EQU 01b
eastVsWest  EQU 10b

pcFormat    EQU  0
gridFormat  EQU  1
$EJECT

CODE SEGMENT PUBLIC 'CODE'
ASSUME  CS:CGROUP

scrOrientation DB north

; ScrSetScreenOrientation: PROCEDURE (newOrientation)
;
; This routine sets the screen orientation for the screen driver's use

newOrientation EQU BYTE PTR [BP+6]

ScrSetScreenOrientation PROC FAR
	PUSH	BP
	MOV	BP, SP
	MOV	AL, newOrientation	; Get the new screen orientation
	AND	AL, 3	; Force it to be in a valid range
	MOV	CS:scrOrientation, AL	; Set the new orientation
	POP	BP
	RET	2
ScrSetScreenOrientation ENDP


; ScrWindowByteSize: PROCEDURE (width, height, format) WORD
;
; This routine returns the number of bytes needed (to be allocated)
; to be large enough for an offscreen window width x height in size
; The format can be either screen format or grid format.

winWidth  EQU WORD PTR [BP+12]
winHeight EQU WORD PTR [BP+10]
winFormat EQU BYTE PTR [BP+8]

ScrWindowByteSize PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP

	MOV	BX, winWidth
	MOV	CX, winHeight
	TEST	CS:scrOrientation, 1
	JZ	ScrWinBSizeNorthSouth

	XCHG	BX, CX	; If east/west then height -> bytesPerLine

ScrWinBSizeNorthSouth:
	ADD	BX, 15	; Make sure that the width is an even
	AND	BX, 0FFF0H	; multiple of 16 (a word) for other rtns

	MOV	AX, 1	; Bits per pixel for grid format is 1
	CMP	winFormat, gridFormat
	JE	HaveBitsPerPixel

	MOV	AX, bitsPerPixel

HaveBitsPerPixel:
	CMP	AL, 1	; If bits per pixel = 1
	JE	BitsPerPixelAre1	; then bit width = width

	MUL	BX
	XCHG	BX, AX	; Bit width = width * bits per pixel

BitsPerPixelAre1:
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1	; Byte width = bit width / 8

	XCHG	AX, CX
	MUL	BX	; Bytes needed = byte width * height

	POP	BP
	POP	DS
	RET	6
ScrWindowByteSize ENDP
$EJECT

; Rotate Pts North

; This routine will take two pts and a width and height and adjust them
; to the absolute (non-rotated) northern oriented pts, width & height.

; An important point: This all works because all screens and offscreen buffers
; are always an exact multiple of 8 in both dimensions (x and y).

; If there is no width or height associated with the routine (i.e. DrawLine)
; then be sure to pass 1 for width and height.  Passing 0 is WRONG!


; INPUT
;   AX = x point
;   BX = y point
;   CX = width
;   SI = height
;   DX = windowWidth
;   DI = windowHeight

; OUTPUT
;   AX = x point (oriented north)
;   BX = y point (oriented north)
;   CX = width (oriented north)
;   SI = height (oriented north)
;   DX = bytes per line (oriented north)
;   DI = windowHeight (oriented north)

RotatePtsNorth PROC NEAR
	TEST	CS:scrOrientation, westOrEast
	JNZ	RotateFromWestOrEast

	ADD	DX, 15
	AND	DX, 0FFF0H	; Round width to next nearest word boundary

  TEST CS:scrOrientation, notNorth
	JZ	RotatedPtsDone

RotatePtsFromSouth:
	ADD	AX, CX	; Add rect width
	SUB	AX, DX	; Subtract window width
	NEG	AX	; x = -(x + rectWidth - windowWidth)
	ADD	BX, SI	; Add rect height
	SUB	BX, DI	; Subtract window height
	NEG	BX	; y = -(y + rectHt - windowHt)
	JMP	SHORT RotatedPtsDone

RotateFromWestOrEast:
	XCHG	AX, BX	; x and y position need to be swapped
	XCHG	DX, DI	; window width and height need to be swapped
	XCHG	CX, SI	; rect width and height need to be swapped

	ADD	DX, 15
	AND	DX, 0FFF0H	; Round width to next nearest word boundary

	TEST	CS:scrOrientation, eastVsWest
	JNZ	RotateFromEast

RotateFromWest:
	ADD	BX, SI	; Add rect height
	SUB	BX, DI	; Subtract window height
	NEG	BX	; y = -(y + rectHt - windowHt)
	JMP	SHORT RotatedPtsDone

RotateFromEast:
	ADD	AX, CX	; Add rect width
	SUB	AX, DX	; Subtract window width
	NEG	AX	; x = -(x + rectWidth - windowWidth)

RotatedPtsDone:
	SHR	DX, 1
	SHR	DX, 1
	SHR	DX, 1	; Return window width as bytes per line

; NOTE: If bitsPerPixel were other than 1 (as it is with this screen driver)
; then you would have to multiple DX by bitsPerPixel to arrive at the correct
; value for bytesPerLine.

	RET
RotatePtsNorth ENDP
$EJECT

; Init Win Parms

; INPUT
;   AX = screen address segment
;   DX = bytes per line
;   DI = windowHeight

; OUTPUT
;   AX = screen address segment (maybe changed if in EMS)
;   BX = rewindDelta (bankHeight * 3 + edge fudge factors)
;   CX = edge (CH = scrFormat = pcFormat; CL = edge)
;   DX = bytes per line
;   DI = bankHeight, actually bankHeightInBytes
;   SI = ems slot to be restored (or -1 if not swapped out)

InitWinParms PROC NEAR
  MOV  CX, AX	; Save screen seg in CX

%IF (%supportsEmsWindows EQ 1) THEN (
  MOV  SI, 0FFFFH	; ems slot for "not swapped" case
) FI

  CMP  AX, screenSeg
  JNE  InitWinNotScreen

  MOV  AX, 2000H
  JMP  SHORT InitWinUsingScreen

InitWinNotScreen:
%IF (%supportsEmsWindows EQ 1) THEN (
  MOV  AX, CX	; Restore AX to screen seg again
  AND  AX, 0FF80H
  CMP  AX, CS:emsBase
  JNE  AltScreenNotInEms

  PUSHF	; Saving direction flag (just in case)
  PUSH ES
  PUSH DI
  PUSH DX

  AND  CX, 07FH	; low 7 bits of window addr has ems slot

  PUSH CX	; Pass slot to set (BYTE parameter)
  INT  71H	; Cp Subsystem Call
  DB   4EH	; CpSetActiveSlot

  MOV  AH, 0
  MOV  SI, AX	; Save old slot in SI

  POP  DX
  POP  DI
  POP  ES
  POPF

  MOV  CX, CS:emsBase

AltScreenNotInEms:
) FI
  MOV  AX, DI
  SHR  AX, 1
  SHR  AX, 1
  MOV  BX, DX	; Save bytesPerLine
  MUL  DX	; bankHeight = (winHt DIV 4) * bytesPerLine
  MOV  DX, BX	; Restore bytesPerLine

InitWinUsingScreen:
  XCHG DI, AX	; AX has windowHeight; DI has bankHeight
  XOR  BX, BX	; init rewindHeight to 0

  TEST AL, 11b	; If edge is 0 (even mult of 4)
  JZ   InitWinAdd3Banks	; then don't add fudge factor

  MOV  BX, DX	; fudge factor = 1 x bytesPerLine
  TEST AL, 10b	; If edge is not 2 or 3
  JZ   InitWinAdd3Banks	; then fudge factor is done

  ADD  BX, BX	; fudge factor is 2 x bytesPerLine
  TEST AL, 01b	; If edge is not 3
  JZ   InitWinAdd3Banks	; then fudge factor is done

  ADD  BX, DX	; else fudge factor is 3 x bytesPerLine

InitWinAdd3Banks:
  ADD  BX, DI
  ADD  BX, DI
  ADD  BX, DI

  XCHG CX, AX	; AX = scr seg (or EMS base)
			; CX will become scr format and edge values 
  AND  CX, 11b	; CH = 0 (pcFormat) and CL = edge

  RET
InitWinParms ENDP
$EJECT

; Computes word address & shift count, given x & y

;INPUT: 
;   AX = y
;   BX = x
;   DX = bytesPerLine
;   DI = next buffer offset
;   CH = screenFormat
;   CL = edge
;
;OUTPUT:
;   DI = offset to word
;   CX = shift count
;   DX = bytesPerLine
;   AX = y mod 4 

StartPosition PROC NEAR
  PUSH SI
  PUSH DX
  PUSH AX              ; save y for later
  XOR  SI, SI          ; initial ptr to buffer (bank 0)
  CMP  CH, pcFormat
  JNE  S0

  PUSH AX              ; Save y pos for later
  AND  AX, 11b         ; AX = AX MOD 4
  JZ   EndJmpTbl2      ; If even mult of 4 lines, then already in bank 0

  PUSH AX              ; Save bank that y reside in for later
  SHL  AX, 1
  NEG  AX              ; index into the 'add bank' table
  ADD  AX, OFFSET EndJmpTbl1
  JMP  AX

  ADD  SI, DI
  ADD  SI, DI
  ADD  SI, DI

EndJmpTbl1:
  POP  AX              ; restore bank that y resides in
  OR   CL, CL          ; if all banks are the same size
  JZ   EndJmpTbl2      ; then don't have to add fudge factor

  CMP  AL, CL          ; If y pos is < edge
  JB   UseLineCnt      ; then use y pos for fudge factor

  XCHG AX, CX          ; else use edge for fudge factor

UseLineCnt:
  SHL  AX, 1
  NEG  AX              ; index into the 'add fudge factor' table
  ADD  AX, OFFSET EndJmpTbl2
  JMP  AX

  ADD  SI, DX
  ADD  SI, DX
  ADD  SI, DX

EndJmpTbl2:
  POP  AX              ; restore y
  SHR  AX, 1
  SHR  AX, 1           ; y = y DIV 4 (gives offset of 'y' within its bank)

S0:
  MUL  DX
  ADD  AX, SI          ; SI = ptr to correct line

  MOV  DI, AX          ; offset to beginning of line
  MOV  AX, BX		        ; get x
  SAR  AX, 1           ; account for bits/pel
  SAR  AX, 1           
  SAR  AX, 1           
  SAR  AX, 1           ; x/16 pels/word
  MOV  CX,0FH

  SHL  AX, 1           ; make it a byte count
  ADD  DI, AX          ; DI points to begin of word

  AND  CX, BX          ; mask out for shift count
  POP  AX
  AND  AX, 11b         ; AX = y MOD 4

  POP  DX
  POP  SI
  RET
StartPosition ENDP

%IF (%supportsEmsWindows EQ 1) THEN (
$EJECT

; Restore EMS Slot

; INPUT
;   AX = ems slot to be restored
;   IT BETTER BE VALID, TOO! (i.e. check for AX=-1 before calling here)

; OUTPUT
;   Total destruction (within limits)

RestoreEmsSlot PROC NEAR
  PUSH AX                     ; Pass slot to restore (BYTE parameter)
  INT  71H                    ; Cp Subsystem Call
  DB   4EH                    ; CpSetActiveSlot
  RET
RestoreEmsSlot ENDP
) FI

CODE ENDS

  END
